/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.GatherReplacementExclusionEvent;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ITargetingRule;
import com.blamejared.crafttweaker.api.zencode.impl.util.PositionUtil;
import com.blamejared.crafttweaker.impl.managers.GenericRecipesManager;
import com.blamejared.crafttweaker.impl.recipes.replacement.EverythingTargetingRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.ExcludingManagersAndDelegatingTargetingRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.ExcludingRecipesAndDelegatingTargetingRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.FullIngredientReplacementRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.IngredientReplacementRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.OutputTargetingRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.RegexTargetingRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.ReplacerAction;
import com.blamejared.crafttweaker.impl.recipes.replacement.SpecificManagersTargetingRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.SpecificModsTargetingRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.SpecificRecipesTargetingRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.StackTargetingReplacementRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.ZenTargetingRule;
import com.blamejared.crafttweaker.impl.recipes.wrappers.WrapperRecipe;
import com.blamejared.crafttweaker.impl.util.NameUtils;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.Event;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.recipe.Replacer")
@Document(value="vanilla/api/recipe/Replacer")
public final class Replacer {
    private static final Function<ResourceLocation, ResourceLocation> DEFAULT_REPLACER = id -> NameUtils.isAutogeneratedName(id) ? id : NameUtils.generateNameFrom(id.func_110624_b() + "." + id.func_110623_a());
    private static final Supplier<BiFunction<ResourceLocation, String, String>> DEFAULT_CUSTOM_FUNCTION = Lazy.concurrentOf(() -> (id, original) -> original);
    private static final Supplier<Map<IRecipeManager, Collection<ResourceLocation>>> DEFAULT_EXCLUSIONS = Lazy.concurrentOf(() -> GenericRecipesManager.RECIPES.getAllManagers().stream().map(Replacer::gatherDefaultExclusions).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
    private final ITargetingRule targetingRule;
    private final List<IReplacementRule> replacementRules;
    private final Map<ResourceLocation, String> userRenames;
    private final BiFunction<ResourceLocation, String, String> userRenamingFunction;
    private final boolean suppressWarnings;
    private final boolean isSimple;

    private Replacer(ITargetingRule rule) {
        this(rule, new ArrayList<IReplacementRule>(), new TreeMap<ResourceLocation, String>(), null, false);
    }

    private Replacer(ITargetingRule targetingRule, List<IReplacementRule> replacementRules, Map<ResourceLocation, String> userRenames, BiFunction<ResourceLocation, String, String> userRenamingFunction, boolean suppressWarnings) {
        this.targetingRule = targetingRule;
        this.replacementRules = new ArrayList<IReplacementRule>(replacementRules);
        this.userRenames = new TreeMap<ResourceLocation, String>(userRenames);
        this.userRenamingFunction = userRenamingFunction;
        this.suppressWarnings = suppressWarnings;
        this.isSimple = targetingRule instanceof SpecificRecipesTargetingRule;
    }

    @ZenCodeType.Method
    public static Replacer forRecipes(WrapperRecipe ... recipes) {
        return new Replacer(SpecificRecipesTargetingRule.of(recipes));
    }

    @ZenCodeType.Method
    public static Replacer forMods(String ... mods) {
        return new Replacer(SpecificModsTargetingRule.of(mods));
    }

    @ZenCodeType.Method
    public static Replacer forTypes(IRecipeManager ... managers) {
        return new Replacer(SpecificManagersTargetingRule.of(managers));
    }

    @Deprecated
    @ZenCodeType.Method
    public static Replacer forAllTypes() {
        return Replacer.forEverything();
    }

    @ZenCodeType.Method
    public static Replacer forEverything() {
        return new Replacer(EverythingTargetingRule.of());
    }

    @Deprecated
    @ZenCodeType.Method
    public static Replacer forAllTypesExcluding(IRecipeManager ... managers) {
        return Replacer.forEverything().excluding(managers);
    }

    @ZenCodeType.Method
    public static Replacer forOutput(IIngredient output, IRecipeManager ... whitelist) {
        return new Replacer(OutputTargetingRule.of(output, whitelist));
    }

    @ZenCodeType.Method
    public static Replacer forRegexTypes(String regex) {
        return new Replacer(RegexTargetingRule.of(regex, false));
    }

    @ZenCodeType.Method
    public static Replacer forRegexRecipes(String regex) {
        return new Replacer(RegexTargetingRule.of(regex, true));
    }

    @ZenCodeType.Method
    public static Replacer forCustomRecipeSet(BiPredicate<WrapperRecipe, IRecipeManager> function) {
        return new Replacer(ZenTargetingRule.of(function));
    }

    private static Pair<IRecipeManager, Collection<ResourceLocation>> gatherDefaultExclusions(IRecipeManager manager) {
        GatherReplacementExclusionEvent event = new GatherReplacementExclusionEvent(manager);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return Pair.of((Object)manager, event.getExcludedRecipes());
    }

    @ZenCodeType.Method
    public Replacer excluding(ResourceLocation ... recipes) {
        return new Replacer(ExcludingRecipesAndDelegatingTargetingRule.of(this.targetingRule, recipes), this.replacementRules, this.userRenames, this.userRenamingFunction, this.suppressWarnings);
    }

    @ZenCodeType.Method
    public Replacer excluding(IRecipeManager ... managers) {
        return new Replacer(ExcludingManagersAndDelegatingTargetingRule.of(this.targetingRule, managers), this.replacementRules, this.userRenames, this.userRenamingFunction, this.suppressWarnings);
    }

    @ZenCodeType.Method
    public Replacer replace(IIngredient from, IIngredient to) {
        if (from instanceof IItemStack) {
            return this.replace((IItemStack)from, to);
        }
        return this.addReplacementRule(IngredientReplacementRule.create(from, to));
    }

    @ZenCodeType.Method(value="replaceStack")
    public Replacer replace(IItemStack from, IIngredient to) {
        return this.addReplacementRule(StackTargetingReplacementRule.create(from, to));
    }

    @ZenCodeType.Method
    public Replacer replaceFully(IIngredient from, IIngredient to) {
        return this.addReplacementRule(FullIngredientReplacementRule.create(from, to));
    }

    @ZenCodeType.Method
    public Replacer explicitlyRename(ResourceLocation oldName, String newName) {
        String actualNewName = this.fix(newName, oldName);
        if (this.userRenames.containsKey(oldName) && !this.userRenames.get(oldName).equals(actualNewName)) {
            CraftTweakerAPI.logError("The same old name '%s' has been specified twice for renaming with two different strings '%s' and '%s': only the former will apply", oldName, this.userRenames.get(oldName), newName);
            return this;
        }
        this.userRenames.put(oldName, actualNewName);
        return this;
    }

    @ZenCodeType.Method
    public Replacer useForRenaming(BiFunction<ResourceLocation, String, String> function) {
        if (this.userRenamingFunction != null) {
            CodePosition position = PositionUtil.getZCScriptPositionFromStackTrace();
            CraftTweakerAPI.logWarning("%sA renaming function has already been specified for this replacer: the old one will be replaced", position == CodePosition.UNKNOWN ? "" : position + ": ");
        }
        return new Replacer(this.targetingRule, this.replacementRules, this.userRenames, function, this.suppressWarnings);
    }

    @ZenCodeType.Method
    public Replacer suppressWarnings() {
        return new Replacer(this.targetingRule, this.replacementRules, this.userRenames, this.userRenamingFunction, true);
    }

    @ZenCodeType.Method
    public void execute() {
        if (this.replacementRules.isEmpty()) {
            return;
        }
        CraftTweakerAPI.apply(new ReplacerAction(this.targetingRule, this.isSimple, Collections.unmodifiableList(this.replacementRules), DEFAULT_EXCLUSIONS.get().values().stream().flatMap(Collection::stream).collect(Collectors.toSet()), this.buildGeneratorFunction(), this.suppressWarnings));
    }

    public Replacer addReplacementRule(IReplacementRule rule) {
        if (rule == IReplacementRule.EMPTY) {
            return this;
        }
        this.replacementRules.add(rule);
        return this;
    }

    private String fix(String newName, ResourceLocation oldName) {
        CodePosition position = PositionUtil.getZCScriptPositionFromStackTrace();
        return NameUtils.fixing(newName, (fixed, mistakes) -> CraftTweakerAPI.logWarning("%sInvalid recipe rename '%s' from '%s', mistakes:\n%s\nThe new rename '%s' will be used", position == CodePosition.UNKNOWN ? "" : position + ": ", newName, oldName, String.join((CharSequence)"\n", mistakes), fixed));
    }

    private Function<ResourceLocation, ResourceLocation> buildGeneratorFunction() {
        if (this.userRenames.isEmpty() && this.userRenamingFunction == null) {
            return DEFAULT_REPLACER;
        }
        BiFunction<ResourceLocation, String, String> customFunction = Optional.ofNullable(this.userRenamingFunction).orElseGet(DEFAULT_CUSTOM_FUNCTION);
        BiFunction<String, String, ResourceLocation> fixer = (custom, original) -> {
            ResourceLocation originalRl = new ResourceLocation("crafttweaker", original);
            if (custom.equals(original) || NameUtils.isAutogeneratedName(originalRl)) {
                return originalRl;
            }
            return NameUtils.fromFixedName(custom, (fixed, mistakes) -> CraftTweakerAPI.logWarning("Invalid recipe rename '%s' specified in custom renaming function, mistakes:\n%s\nThe new rename will be '%s'", custom, String.join((CharSequence)"\n", mistakes), fixed));
        };
        return id -> {
            String original = Optional.ofNullable(this.userRenames.get(id)).orElseGet(() -> DEFAULT_REPLACER.apply((ResourceLocation)id).func_110623_a());
            return (ResourceLocation)fixer.apply((String)customFunction.apply((ResourceLocation)id, original), original);
        };
    }
}

